# -*- coding: cp1252 -*-


######################################################################
#
# Name:  Collect Maya Versions
# Author:  Royal Render, Holger Schoenberger, Binary Alchemy
# Version: 
# Description: 
#   This script creates a batch file start starts all maya versions found locally with a print version command.
#   The version is grabbed by rrParseOutput and added to a client table.
#
# Copyright (c) Holger Schoenberger - Binary Alchemy
######################################################################
import os



winMayaInstallLocation= "c:\\Program Files\\Autodesk\\Maya*\\bin\\mayapy.exe"

versionsToTest= []
versionsToTest.append("2015")
versionsToTest.append("2016")
versionsToTest.append("2016.5")
versionsToTest.append("2017")
versionsToTest.append("2018")
versionsToTest.append("2019")
versionsToTest.append("2020")



fileBaseName=rrGlobal.rrRootPath()+"inhouse\\rrCollectMayaVersion"
if (not os.path.isdir(rrGlobal.rrRootPath()+"inhouse")):
    os.mkdir(rrGlobal.rrRootPath()+"inhouse")


batchF = rrGlobal.getCrossBatch()
batchF.setBaseFileName(fileBaseName)

batchF.osVarAdd("ErrorLevel","%ERRORLEVEL%","$?","$?")  #Note: debian uses $status and not $?
batchF.osVarAdd("rrParseOutput_Exe","rrParseOutput","rrParseOutput","rrParseOutput.app\Contents\MacOS\rrParseOutput")

batchF.addLine("<comment> This file was automatically created by a rrSubmitter Scripted Job Plugin ")
batchF.addEnd()

for verTest in versionsToTest:
    mayaPath= winMayaInstallLocation
    mayaPath= mayaPath.replace("*",verTest)
    batchF.addFlag("<rrBin><rrParseOutput_Exe>")
    batchF.addFlag('"'+mayaPath+'" -c  \'import maya.standalone; maya.standalone.initialize(name="python"); import time; import maya.cmds as cmds;import sys; version= cmds.about(apiVersion=True);print ("Maya Version: "+str(version)+".");sys.stdout.flush();time.sleep(5);\'   ')
    batchF.addFlag("table")
    batchF.addFlag(fileBaseName+"_result_"+verTest+".csv")
    batchF.addFlag("-showCmdOutput")
    batchF.addFlag("-addAllClients")
    batchF.addFlag("Workstation,Unique=[host]")
    batchF.addFlag("Updated=[dateMonth]")
    batchF.addFlag("Executed=[success]")
    batchF.addFlag("Version=Maya Version:;;.")
    batchF.addFlag("Err=[error]")
    batchF.addEnd()
    batchF.addEnd()
    

if not batchF.saveWin():
    raise Exception(batchF.fileErrorMessage())

    
    


#Create a job
renderApp= rrJob._RenderAppBasic()
renderApp.clear()
renderApp.name="Execute"
renderApp.type="Execute"
renderApp.executeType=rrGlobal.executeJobType.onceEachClient
renderApp.rendererName="Maya Version Check"



newJob=  rr.getNewJob()
newJob.sceneName=batchF.getOSFileName(0);
newJob.renderApp=renderApp
newJob.companyProjectName="rrCommand"
newJob.imageFileName=fileBaseName+"_resultxxxx.csv"
newJob.imageSingleOutputFile=True
newJob.splitImageFileInto_DirFileExt(False)
newJob.uiIsChecked= True
newJob.layer="Maya Version Check"

rr.setSubmitterParameter("MaxClientsAtATime=0~5") #too many clients writing to the same csv file might be an issue



rr.jobAll_set(999,newJob);  # If the index of the job is higher than the number of jobs,
                            # then a new job is added to the end of the job list. So I use 999.